﻿Public Class Form1
    Dim DirPath As String                    ' this is the directory path
    Dim vs, hs As Integer                    ' these are for the vertical and horizontal scales
    Dim t, bt, s As Integer                  ' this is the time period
    Dim vg, hg As Integer                    ' these are the gaps between the little boxes
    Dim w0, h0, w1 As Integer                ' these are the starting positions of the instructions and the tree
    Dim wb, hb As Integer                    ' these are the width and height of the big box
    Dim BigBox As Label                      ' This is the big box
    Dim Box(20, 20) As Label                 ' These are the little boxes
    Dim CashFlowBox(20, 20) As Label         ' These are the cashflow boxes
    Dim ProbabilityBox(20, 20) As Label      ' These are the probability boxes
    Dim TopSmallBox(20, 20) As Integer       ' This is the top of the small box
    Dim HeightSmallBox As Integer            ' This is the height of the small box
    Dim X(20, 20) As Integer                 ' These are the cash flows
    Dim p(20, 20) As Double                  ' These are the probabilities
    Dim q As Single                          ' This is the binomial probability
    Dim h As Integer                         ' This is the increment
    Dim sgap As Integer                      ' This is the small gap between the cash flow box and the probability box
    Dim Instructions As Label                ' This is going to contain the instructions
    Dim StopButton, ContinueButton, ConfirmButton As Button ' These are the various buttons
    Dim WidthButton, HeightButton            'These are the widths and heights of the stop and continue buttons
    Dim StopDecision, ContinueDecision, ConfirmDecision As Integer ' These are to indicate the decision of the subject
    Dim pt, ps As Integer                    ' These are the current period and the state of the current period
    Dim value As Integer                     ' This is the value of the random variable
    Dim m As Integer                         'This number is subtracted from the maximum number of states in each time period when the cash flows move up
    Dim randomizer As New Random
    Dim time As Integer
    Dim MinTD(20), MaxTD(20) As Integer
    Dim TimeLeft As Label
    Dim SecondsLeft As Integer
    Dim qval(20) As Single                    'these are the q values
    Dim hval(20), btval(20) As Integer        ' these are the h and bt values
    Dim pn, np As Integer                     'These are the problem number and the number of problems
    Dim numcl(1000) As Integer                 ' this is the number of clicks in a particular problem)
    Dim clicks(100, 100), times(100, 100) As Integer
    Dim cn As Integer                         'click number
    Dim TotalTime As Integer                  'Total time elapsed in seconds from start of experiment
    Dim EndOfProblem As Integer               'This takes the value 0 until the end of a problem and then takes the value 1

    Private Sub BuildTree()

        'creating and positioning TimeLeft Label
        TimeLeft = New Label
        TimeLeft.Width = 0.25 * wb
        TimeLeft.Height = 0.06 * hb
        TimeLeft.Left = w1 + 0.075 * hs
        TimeLeft.Top = h0 + hb - 0.7 * vs
        Me.TimeLeft.Font = New System.Drawing.Font("", 150 / bt)
        TimeLeft.BorderStyle = BorderStyle.FixedSingle
        Me.Controls.Add(TimeLeft)
        TimeLeft.Visible = True
        TimeLeft.ForeColor = Color.Blue
        TimeLeft.Text = CStr(MaxTD(pn)) + " Seconds left"

        'first defining the top and the heights of the small boxes
        HeightSmallBox = (hb - (bt + 2) * vg) / bt
        t = 1
        Do While t <= bt
            s = 1
            Do While s <= t
                TopSmallBox(t, s) = h0 + (HeightSmallBox * (bt - t)) / 2 + (s - 1) * HeightSmallBox + (s - 0.5) * vg
                s = s + 1
            Loop
            t = t + 1
        Loop

        'the cash flow boxes
        t = 1
        Do While t <= bt
            s = 1
            Do While s <= t
                CashFlowBox(t, s) = New Label
                CashFlowBox(t, s).Width = (wb - (bt + 2) * hg) / bt
                CashFlowBox(t, s).Height = (HeightSmallBox - 7 * sgap) / 2
                CashFlowBox(t, s).Left = w1 + t * hg + (t - 1) * (CashFlowBox(t, s).Width) + hg
                CashFlowBox(t, s).Top = TopSmallBox(t, s) + 3 * sgap
                Me.CashFlowBox(t, s).Font = New System.Drawing.Font("", 100 / bt)
                CashFlowBox(t, s).BorderStyle = BorderStyle.FixedSingle
                Me.Controls.Add(CashFlowBox(t, s))
                CashFlowBox(t, s).Visible = True
                CashFlowBox(t, s).ForeColor = Color.Red
                s = s + 1
            Loop
            t = t + 1
        Loop

        'the probability boxes
        t = 1
        Do While t <= bt
            s = 1
            Do While s <= t
                ProbabilityBox(t, s) = New Label
                ProbabilityBox(t, s).Width = CashFlowBox(t, s).Width
                ProbabilityBox(t, s).Height = CashFlowBox(t, s).Height
                ProbabilityBox(t, s).Left = w1 + t * hg + (t - 1) * (ProbabilityBox(t, s).Width) + hg
                ProbabilityBox(t, s).Top = TopSmallBox(t, s) + 4 * sgap + CashFlowBox(t, s).Height
                Me.ProbabilityBox(t, s).Font = New System.Drawing.Font("", 80 / bt)
                ProbabilityBox(t, s).BorderStyle = BorderStyle.FixedSingle
                Me.Controls.Add(ProbabilityBox(t, s))
                If t > 1 Then ProbabilityBox(t, s).Visible = True
                If t = 1 Then ProbabilityBox(t, s).Visible = False
                ProbabilityBox(t, s).ForeColor = Color.Blue
                s = s + 1
            Loop
            t = t + 1
        Loop

        'now for the little boxes
        t = 1
        Do While t <= bt
            s = 1
            Do While s <= t
                Box(t, s) = New Label
                Box(t, s).Width = (wb - (bt + 2) * hg) / bt
                Box(t, s).Height = (hb - (bt + 2) * vg) / bt
                Box(t, s).Left = w1 + t * hg + (t - 1) * (Box(t, s).Width) + hg
                Box(t, s).Top = h0 + ((Box(t, s).Height) * (bt - t)) / 2 + (s - 1) * (Box(t, s).Height) + (s - 0.5) * vg
                Me.Box(t, s).Font = New System.Drawing.Font("", 8)
                'Box(t, s).BorderStyle = BorderStyle.FixedSingle
                Me.Controls.Add(Box(t, s))
                Box(t, s).Visible = False
                s = s + 1
            Loop
            t = t + 1
        Loop

        'now for the big box
        BigBox = New Label
        BigBox.Left = w1
        BigBox.Top = h0
        BigBox.Width = wb
        BigBox.Height = hb
        Me.BigBox.Font = New System.Drawing.Font("", 15)
        BigBox.BorderStyle = BorderStyle.FixedSingle
        Me.Controls.Add(BigBox)
        BigBox.Visible = True
        BigBox.Text = "Cash Flows and Probabilities"
    End Sub
    Private Sub CalculateCashFlows()
        t = 2
        Do While t <= bt
            s = 1
            Do While s <= t
                If s = 1 Then
                    X(t, 1) = X(t - 1, 1) + h
                Else
                    X(t, s) = X(t, s - 1) - 2 * h
                End If
                s = s + 1
            Loop
            t = t + 1
        Loop
    End Sub

    Private Sub CalculateProbabilities()
        t = 1
        s = 1
        bt = 10
        p(t, s) = 1
        If t = 1 Then
            p(t + 1, s) = p(t, s) * q
            p(t + 1, s + 1) = p(t, s) * (1 - q)
        End If
        t = t + 2
        Do While t <= bt
            s = 1
            Do While s <= t
                If s = 1 Then
                    p(t, s) = p(t - 1, s) * q
                    s = s + 1
                End If
                Do While s > 1 And s < t
                    p(t, s) = p(t - 1, s - 1) * (1 - q) + p(t - 1, s) * q
                    s = s + 1
                Loop
                If s = t Then
                    p(t, s) = p(t - 1, s - 1) * (1 - q)
                    s = s + 1
                End If
            Loop
            t = t + 1
        Loop
    End Sub

    Private Sub Confirm()

        MsgBox(CStr(EndOfProblem))

        If EndOfProblem = 1 Then
            cn = cn + 1
            clicks(pn, cn) = 4
            numcl(pn) = cn
            pn = pn + 1
            If pn <= np Then RunProblem()
            If pn > np Then EndExperiment()
            StopDecision = 0
            ContinueDecision = 0
            ConfirmDecision = 0
            ConfirmButton.Visible = False
            ConfirmButton.Text = "Click to confirm"
        End If

        If EndOfProblem = 0 Then
            ConfirmButton.Text = "Click to confirm"
            cn = cn + 1
            clicks(pn, cn) = 3
            numcl(pn) = cn
            times(cn, pn) = TotalTime
            SecondsLeft = MaxTD(pn)
            ContinueButton.Visible = False
            StopButton.Visible = False
            ConfirmButton.Visible = False
            TimeLeft.Text = CStr(SecondsLeft) + " seconds left"
            t = 1
            If t <= bt And pt < bt Then
                t = pt
                s = ps
                If StopDecision = 1 And ContinueDecision = 0 Then
                    TimeLeft.Visible = False
                    TimeLeft.Visible = False
                    Timer.Enabled = False
                    ConfirmButton.Visible = True
                    DeleteBox()
                    If pn < np Then
                        ConfirmButton.Text = "Please click to move onto the next problem."
                    End If
                    EndOfProblem = 1
                End If
                If pt <> bt Then
                    Randomize()
                    If ContinueDecision = 1 And StopDecision = 0 Then
                        SecondsLeft = MaxTD(pn) + 1
                        value = Int(Rnd() * 100) + 1
                        If value <= (q * 100) Then
                            ps = s
                            CashFlowBox(t, s).Visible = False
                            ProbabilityBox(t, s).Visible = False
                            t = t + 1
                            pt = t
                            Do While t <= bt
                                CashFlowBox(t, s + 1).Visible = False
                                ProbabilityBox(t, s + 1).Visible = False
                                s = s + 1
                                t = t + 1
                            Loop
                            t = pt
                            s = ps
                            m = m + 1
                            ProbabilityBox(pt, ps).Visible = False
                            'p(pt, ps) = 1
                            'ProbabilityBox(pt, ps).Text = CStr(Math.Round(p(pt, ps), 4))
                            If pt = t And t <> bt Then
                                t = t + 1
                                p(t, s) = p(pt, ps) * q
                                ProbabilityBox(t, s).Text = CStr(Math.Round(p(t, s), 4))
                                p(t, s + 1) = p(pt, ps) * (1 - q)
                                ProbabilityBox(t, s + 1).Text = CStr(Math.Round(p(t, s + 1), 4))
                            End If
                            If pt = t Then
                                ProbabilityBox(pt, ps).Visible = False
                                'p(pt, ps) = 1
                                'ProbabilityBox(pt, ps).Text = CStr(Math.Round(p(pt, ps), 4))
                            End If
                            t = pt + 2
                            Do While t <= bt
                                s = ps
                                If s = ps Then
                                    p(t, s) = p(t - 1, s) * q
                                    ProbabilityBox(t, s).Text = CStr(Math.Round(p(t, s), 4))
                                    s = s + 1
                                End If
                                Do While s > ps And s < t - m
                                    p(t, s) = p(t - 1, s - 1) * (1 - q) + p(t - 1, s) * q
                                    ProbabilityBox(t, s).Text = CStr(Math.Round(p(t, s), 4))
                                    s = s + 1
                                Loop
                                If s = t - m Then
                                    p(t, s) = p(t - 1, s - 1) * (1 - q)
                                    ProbabilityBox(t, s).Text = CStr(Math.Round(p(t, s), 4))
                                    s = s + 1
                                End If
                                t = t + 1
                            Loop
                        Else
                            ps = s + 1
                            pt = t + 1
                            Do While t <= bt
                                CashFlowBox(t, s).Visible = False
                                ProbabilityBox(t, s).Visible = False
                                t = t + 1
                            Loop
                            t = pt
                            s = ps
                            ProbabilityBox(pt, ps).Visible = False
                            'p(pt, ps) = 1
                            'ProbabilityBox(pt, ps).Text = CStr(Math.Round(p(pt, ps), 4))
                            If pt = t And t <> bt Then
                                t = t + 1
                                p(t, s) = p(pt, ps) * q
                                ProbabilityBox(t, s).Text = CStr(Math.Round(p(t, s), 4))
                                p(t, s + 1) = p(pt, ps) * (1 - q)
                                ProbabilityBox(t, s + 1).Text = CStr(Math.Round(p(t, s + 1), 4))
                            End If
                            If pt = t Then
                                ProbabilityBox(pt, ps).Visible = False
                                'p(pt, ps) = 1
                                'ProbabilityBox(pt, ps).Text = CStr(Math.Round(p(pt, ps), 4))
                            End If
                            t = pt + 2
                            Do While t <= bt
                                s = ps
                                If s = ps Then
                                    p(t, s) = p(t - 1, s) * q
                                    ProbabilityBox(t, s).Text = CStr(Math.Round(p(t, s), 4))
                                    s = s + 1
                                End If
                                Do While s > ps And s < t - m
                                    p(t, s) = p(t - 1, s - 1) * (1 - q) + p(t - 1, s) * q
                                    ProbabilityBox(t, s).Text = CStr(Math.Round(p(t, s), 4))
                                    s = s + 1
                                Loop
                                If s = t - m Then
                                    p(t, s) = p(t - 1, s - 1) * (1 - q)
                                    ProbabilityBox(t, s).Text = CStr(Math.Round(p(t, s), 4))
                                    s = s + 1
                                End If
                                t = t + 1
                            Loop
                        End If
                    End If
                End If
                If pt = bt Then
                    TimeLeft.Visible = False
                    TimeLeft.Visible = False
                    BigBox.Visible = False
                    DeleteBox()
                    If pn < np Then
                        ConfirmButton.Visible = True
                        ConfirmButton.Text = "Please click to move onto the next problem."
                        EndOfProblem = 1
                    End If
                End If
            End If
        End If



    End Sub
    Private Sub ContinueProblem()
        cn = cn + 1
        numcl(pn) = cn
        clicks(pn, cn) = 1
        times(pn, cn) = TotalTime
        ConfirmButton.Visible = True
        ContinueDecision = 1
        StopDecision = 0
    End Sub
    Private Sub DeleteBox()
        BigBox.Visible = False
        TimeLeft.Visible = False
        t = 1
        Do While t <= bt
            s = 1
            Do While s <= t
                ProbabilityBox(t, s).Visible = False
                Box(t, s).Visible = False
                CashFlowBox(t, s).Visible = False
                s = s + 1
            Loop
            t = t + 1
        Loop
    End Sub
    Private Sub EndExperiment()
        WriteOutput()
        MsgBox("All Over!")
    End Sub

    Private Sub Form1_Load(sender As Object, e As EventArgs) Handles MyBase.Load
        Me.WindowState = FormWindowState.Maximized
        DirPath = "c:\active\people\mari\vs program 14"
        TotalTimer.Enabled = True
        TotalTime = 0
        SetParameters()
        ReadProblems()
        pn = 1
        EndOfProblem = 0
        RunProblem()
    End Sub

    Private Sub InsertButtons()
        StopButton = New Button
        StopButton.Width = 0.2 * wb
        StopButton.Left = w1 + BigBox.Width - StopButton.Width
        StopButton.Top = BigBox.Top + BigBox.Height + 20 * sgap
        StopButton.Height = 0.2 * hb
        Me.StopButton.Font = New System.Drawing.Font("", 15)
        Me.Controls.Add(StopButton)
        StopButton.Visible = False
        AddHandler StopButton.Click, AddressOf StopProblem
        'this is a key line to make the Click on Stop work - it calls the routine Stop below
        StopButton.Text = "Stop"

        ContinueButton = New Button
        ContinueButton.Left = w1
        ContinueButton.Top = BigBox.Top + BigBox.Height + 20 * sgap
        ContinueButton.Width = 0.2 * wb
        ContinueButton.Height = 0.2 * hb
        Me.ContinueButton.Font = New System.Drawing.Font("", 15)
        Me.Controls.Add(ContinueButton)
        ContinueButton.Visible = False
        AddHandler ContinueButton.Click, AddressOf ContinueProblem
        'this is a key line to make the Click on continue work - it calls the routine continueproblem below
        ContinueButton.Text = "Continue"

        ConfirmButton = New Button
        ConfirmButton.Left = w1 + ContinueButton.Width + (BigBox.Width - 4 * ContinueButton.Width) / 2
        ConfirmButton.Top = StopButton.Top + StopButton.Height + 10 * sgap
        ConfirmButton.Width = 0.4 * wb
        ConfirmButton.Height = 0.2 * hb
        Me.ConfirmButton.Font = New System.Drawing.Font("", 15)
        Me.Controls.Add(ConfirmButton)
        ConfirmButton.Visible = False
        AddHandler ConfirmButton.Click, AddressOf Confirm
        'this is a key line to make the Click on Confirm work - it calls the routine Confirm below
        ConfirmButton.Text = "Click to Confirm"


    End Sub
    Private Sub InsertCashFlows()
        t = 1
        Do While t <= bt
            s = 1
            Do While s <= t
                CashFlowBox(t, s).Text = CStr(X(t, s))
                s = s + 1
            Loop
            t = t + 1
        Loop
    End Sub

    Private Sub InsertProbabilities()
        t = 1
        Do While t <= bt
            s = 1
            Do While s <= t
                ProbabilityBox(t, s).Text = CStr(Math.Round(p(t, s), 4))
                s = s + 1
            Loop
            t = t + 1
        Loop
    End Sub

    Private Sub MakeBordersOfSmallBoxesVisible()
        t = 1
        Do While t <= bt
            s = 1
            Do While s <= t
                Box(t, s).BorderStyle = BorderStyle.FixedSingle
                s = s + 1
            Loop
            t = t + 1
        Loop
    End Sub
    Private Sub ReadProblems()
        Dim ProblemsPath As String
        Dim lpn, lrn As Integer
        ProblemsPath = DirPath + "\problems.txt"
        lpn = 1
        Using ProblemsReader As New Microsoft.VisualBasic.FileIO.TextFieldParser(ProblemsPath)
            ProblemsReader.TextFieldType = FileIO.FieldType.Delimited
            ProblemsReader.SetDelimiters(" ")
            Dim currentRow As String()
            lpn = 1
            While Not ProblemsReader.EndOfData
                currentRow = ProblemsReader.ReadFields()
                Dim currentField As String
                lrn = 1
                For Each currentField In currentRow
                    If lrn = 1 Then qval(lpn) = CSng(currentField)
                    If lrn = 2 Then hval(lpn) = CInt(currentField)
                    If lrn = 3 Then btval(lpn) = CInt(currentField)
                    If lrn = 4 Then MinTD(lpn) = CInt(currentField)
                    If lrn = 5 Then MaxTD(lpn) = CInt(currentField)
                    lrn = lrn + 1
                Next
                'MsgBox("problem " + CStr(lpn) + "  " + CStr(qval(lpn)) + " " + CStr(hval(lpn)) + " " + CStr(btval(lpn)) + " " + CStr(MinTD(lpn)) + " " + CStr(MaxTD(lpn)))
                np = lpn
                lpn = lpn + 1
            End While
        End Using
        'MsgBox(CStr(np))
    End Sub
    Private Sub RunProblem()
        EndOfProblem = 0
        cn = 0
        t = 1
        pt = 1
        s = 1
        ps = 1
        q = qval(pn)
        h = hval(pn)
        bt = btval(pn)
        CalculateCashFlows()
        CalculateProbabilities()
        BuildTree()
        InsertButtons()
        InsertCashFlows()
        InsertProbabilities()
        WriteInstructions()
        ConfirmButton.Visible = False
        ConfirmButton.Text = "Click to Confirm"
        Timer.Enabled = True
        ConfirmButton.Visible = False
        SecondsLeft = MaxTD(pn) + 1
    End Sub

    Private Sub SetParameters()
        vs = 45 ' 50 at work
        hs = 60 ' 75 at work
        'q = 0.5
        'h = 10
        'bt = 10
        wb = 10.0 * hs
        hb = 10.0 * vs
        w0 = hs
        w1 = 12 * hs
        h0 = 0.5 * vs
        X(1, 1) = 10
        p(1, 1) = 1
        vg = 0.005 * hb
        hg = 0.001 * wb
        sgap = 0.025 * (hb / 10)
        WidthButton = wb / 10
        HeightButton = hb / 10
        StopDecision = 0
        ContinueDecision = 0
        ConfirmDecision = 0
        pt = 1
        ps = 1
        t = 1
        s = 1
        m = 0
        'MinTD = 1
        'MaxTD = 20
        'time = MaxTD
        Timer.Interval = 1000
    End Sub

    Private Sub StopProblem()
        cn = cn + 1
        clicks(pn, cn) = 2
        numcl(pn) = cn
        times(cn, pn) = TotalTime
        ConfirmButton.Visible = True
        StopDecision = 1
        ContinueDecision = 0
    End Sub

    Private Sub Timer_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer.Tick
        SecondsLeft = SecondsLeft - 1
        'TimeLeft.Enabled = True
        'TimeLeft.Visible = True
        TimeLeft.Text = CStr(SecondsLeft) + " seconds left"
        If SecondsLeft > MaxTD(pn) - MinTD(pn) Then
            ContinueButton.Visible = False
            StopButton.Visible = False
            ConfirmButton.Visible = False
        End If
        If SecondsLeft > 0 Then
            TimeLeft.Text = CStr(SecondsLeft) + " seconds left"
            If SecondsLeft <= MaxTD(pn) - MinTD(pn) + 1 Then
                If ConfirmDecision <> 1 Then
                    StopButton.Visible = True
                    ContinueButton.Visible = True
                    If ContinueDecision = 1 Then
                        ConfirmDecision = 1
                    End If
                    If StopDecision = 1 Then
                        ConfirmDecision = 1
                    End If
                End If
            End If
        ElseIf SecondsLeft = 0 And pt <> bt Then
            If StopDecision <> 1 And ConfirmDecision <> 1 Then
                TimeLeft.Enabled = False
                MsgBox("Time is up", , "Care")
                ContinueDecision = 1
                Confirm()
                TimeLeft.Text = MaxTD(pn)
            End If
        End If
    End Sub

    Private Sub WriteInstructions()
        Instructions = New Label
        Instructions.Left = w0
        Instructions.Top = h0
        Instructions.Width = wb
        Instructions.Height = hb
        Me.Instructions.Font = New System.Drawing.Font("", 15)
        Instructions.BorderStyle = BorderStyle.FixedSingle
        Me.Controls.Add(Instructions)
        Instructions.Visible = True
        Instructions.Text = "Instructions"
    End Sub

    Private Sub WriteOutput()
        'Where you are running the program from is called DirPath
        Dim Output As String
        Dim OutputFile As String
        OutputFile = DirPath + "\output data\output.txt"
        Dim OutputWriter As New System.IO.StreamWriter(OutputFile, append:=False)
        MsgBox("here")
        pn = 1
        Do While pn <= np
            cn = 1
            Do While cn <= numcl(pn)
                Output = CStr(pn) + " " + CStr(cn) + " " + CStr(pt) + " " + CStr(times(pn, cn)) + " " + CStr(clicks(pn, cn))
                MsgBox(Output)
                OutputWriter.WriteLine(Output)
                cn = cn + 1
            Loop
            pn = pn + 1
        Loop
        OutputWriter.Close()
    End Sub

    Private Sub TotalTimer_Tick(sender As Object, e As EventArgs) Handles TotalTimer.Tick
        TotalTime = TotalTime + 1
    End Sub
End Class